<?php
	global $VISUAL_COMPOSER_EXTENSIONS;
	
	// Define Shortcode (Fields) Settings and Defaults
	function TS_VCSC_Generator_Callbacks($callback) {
		if ($callback == "shortcode") {
			return array(
				// General Settings
				'icon_replace'				=> 'false',
				'icon' 						=> '',
				'icon_image'				=> '',
				'icon_color'				=> '#cccccc',
				'icon_background'			=> 'rgba(255, 255, 255, 0)',
				'icon_size_type'			=> 'px',
				'icon_size_slide'           => 30,
				'icon_size_points'			=> 30,
				'icon_size_ems'				=> 2,
				'icon_size_rem'				=> 2,
				'icon_size_percent'			=> 200,
				'icon_size_viewheight'		=> 2,
				'icon_size_viewwidth'		=> 2,
				'icon_frame_type' 			=> '',
				'icon_frame_thick'			=> 1,
				'icon_frame_radius'			=> '',
				'icon_frame_color'			=> '#000000',
				'padding' 					=> 'false',
				'icon_padding' 				=> 0,
				'icon_align' 				=> '',
				'link' 						=> '',
				'link_target'				=> '_parent',
				// Scroll Settings
				'scroll_navigate'			=> 'none',
				'scroll_target'				=> '',
				'scroll_speed'				=> 2000,
				'scroll_effect'				=> 'linear',
				'scroll_offset'				=> 'desktop:0px;tablet:0px;mobile:0px',
				'scroll_hashtag'			=> 'false',
				'scroll_placement'			=> 'bottomright',
				'scroll_distance'			=> 200,
				'scroll_left'				=> 20,
				'scroll_right'				=> 20,
				'scroll_top'				=> 20,
				'scroll_bottom'				=> 20,
				// Tooltip Settings
				'tooltip_css'				=> 'false',
				'tooltip_content'			=> '',
				'tooltip_base64'			=> '',
				'tooltip_position'			=> 'ts-simptip-position-top',
				'tooltip_style'				=> 'ts-simptip-style-black',
				'tooltip_animation'			=> 'swing',
				'tooltipster_offsetx'		=> 0,
				'tooltipster_offsety'		=> 0,
				// Animation Settings
				'animation_active'			=> '',
				'animation_icon'			=> '',
				'animation_view' 			=> '',
				'animation_totopin'			=> '',
				'animation_totopout'		=> '',
				'animation_delay' 			=> 0,
				// Other Settings
				'margin_top'				=> 0,
				'margin_bottom'				=> 0,
				'el_id' 					=> '',
				'el_class' 					=> '',
				'css'						=> '',
			);
		} else if ($callback == "bordertypes") {
			return array(
				'solid', 'dotted', 'dashed', 'double', 'groove', 'ridge', 'inset', 'outset',
			);
		} else if ($callback == "easingtypes") {
			return array(
				"Linear"					=> "linear",
				"Ease In Sine"				=> "easeInSine",
				"Ease Out Sine"				=> "easeOutSine",
				"Ease In Out Sine"			=> "easeInOutSine",
				"Ease In Quad"				=> "easeInQuad",
				"Ease Out Quad"				=> "easeOutQuad",
				"Ease In Out Quad"			=> "easeInOutQuad",
				"Ease In Cubic"				=> "easeInCubic",
				"Ease Out Cubic"			=> "easeOutCubic",
				"Ease In Out Cubic"			=> "easeInOutCubic",
				"Ease In Quart"				=> "easeInQuart",
				"Ease Out Quart"			=> "easeOutQuart",
				"Ease In Out Quart"			=> "easeInOutQuart",        
				"Ease In Quint"				=> "easeInQuint",
				"Ease Out Quint"			=> "easeOutQuint",
				"Ease In Out Quint"			=> "easeInOutQuint",        
				"Ease In Expo"				=> "easeInExpo",
				"Ease Out Expo"				=> "easeOutExpo",
				"Ease In Out Expo"			=> "easeInOutExpo",        
				"Ease In Circ"				=> "easeInCirc",
				"Ease Out Circ"				=> "easeOutCirc",
				"Ease In Out Circ"			=> "easeInOutCirc",
				"Ease In Back"				=> "easeInBack",
				"Ease Out Back"				=> "easeOutBack",
				"Ease In Out Back"			=> "easeInOutBack",        
				"Ease In Elastic"			=> "easeInElastic",
				"Ease Out Elastic"			=> "easeOutElastic",
				"Ease In Out Elastic"		=> "easeInOutElastic",
				"Ease In Bounce"			=> "easeInBounce",
				"Ease Out Bounce"			=> "easeOutBounce",
				"Ease In Out Bounce"		=> "easeInOutBounce",
			);
		} else if ($callback == "tooltipsstyles") {
			return array(
				__( "Black", "ts_visual_composer_extend" )                                  => "tooltipster-black",
				__( "Gray", "ts_visual_composer_extend" )                                   => "tooltipster-gray",
				__( "Green", "ts_visual_composer_extend" )                                  => "tooltipster-green",
				__( "Blue", "ts_visual_composer_extend" )                                   => "tooltipster-blue",
				__( "Red", "ts_visual_composer_extend" )                                    => "tooltipster-red",
				__( "Orange", "ts_visual_composer_extend" )                                 => "tooltipster-orange",
				__( "Yellow", "ts_visual_composer_extend" )                                 => "tooltipster-yellow",
				__( "Purple", "ts_visual_composer_extend" )                                 => "tooltipster-purple",
				__( "Pink", "ts_visual_composer_extend" )                                   => "tooltipster-pink",
				__( "White", "ts_visual_composer_extend" )                                  => "tooltipster-white",
				__( "Custom", "ts_visual_composer_extend" )                                 => "tooltipster-custom",
			);
		} else if ($callback == "tooltipspositions") {
			return array(
				__("Top", "ts_visual_composer_extend")                                      => "top",
				__("Bottom", "ts_visual_composer_extend")                                   => "bottom",
				__("Left", "ts_visual_composer_extend")                                     => "left",
				__("Right", "ts_visual_composer_extend")                                    => "right",
			);
		} else if ($callback == "tooltipsvertical") {
			return array(
				__("Top", "ts_visual_composer_extend")                                      => "top",
				__("Bottom", "ts_visual_composer_extend")                                   => "bottom",
			);
		} else if ($callback == "tooltipshorizontal") {
			return array(
				__("Left", "ts_visual_composer_extend")                                     => "left",
				__("Right", "ts_visual_composer_extend")                                    => "right",
			);
		} else if ($callback == "tooltipsanimations") {
			return array(
				__("Swing", "ts_visual_composer_extend")                                    => "swing",
				__("Fall", "ts_visual_composer_extend")                 	                => "fall",
				__("Grow", "ts_visual_composer_extend")                 	                => "grow",
				__("Slide", "ts_visual_composer_extend")                 	                => "slide",
				__("Fade", "ts_visual_composer_extend")                 	                => "fade",
			);
		} else {
			return array();
		}
	}

	function TS_VCSC_Generator_Fields() {
		global $VISUAL_COMPOSER_EXTENSIONS;
		
		$VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconFontsArrays(true);

		if (class_exists('CSF')) {
			$prefix_short_opts           		= 'ts-composium-shortcode';
			
			CSF::createShortcoder($prefix_short_opts, array(
				'button_title' 					=> 'Font Icon',
				'select_title'					=> 'Select Shortcode',
				'insert_title'					=> 'Add New Shortcode',
				'show_in_editor'				=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_UseTinyMCEGenerator == "true" ? true : false),
				'show_in_custom'				=> true,
				'defaults'						=> TS_VCSC_Generator_Callbacks('shortcode'),
				'add_to_gutenberg'				=> false,
				'gutenberg'      				=> array(
					'title'        						=> 'Composium Shortcode',
					'description'  						=> 'Composium Shortcode Block',
					'icon'         						=> 'awards',
					'category'     						=> 'widgets',
					'keywords'     						=> array( 'composium', 'shortcode', 'generate' ),
					'placeholder'  						=> __( 'Add icon here ...', 'ts_visual_composer_extend' ),
				)
			));
			
			// Create Shortcode Generator Options
			CSF::createSection($prefix_short_opts, array(
				'title'     					=> 'Font Icon Shortcode',
				'view'      					=> 'normal',
				'shortcode'						=> 'TS-VCSC-Font-Icons',				
				'fields'    					=> array(
					// Selection Settings
					array(
						'id'					=> 'defaultsgenerator',
						'type'					=> 'defaultsgenerator',
						'value'					=> json_encode(TS_VCSC_Generator_Callbacks('shortcode'), JSON_UNESCAPED_UNICODE),
						'generator'				=> 'ts-composium-shortcode',
					),
					array(
						'type'					=> "heading",
						'content'				=> __( 'Selection Settings', "ts_visual_composer_extend" ),
					),
					array(
						'type'    				=> 'submessage',
						'style'   				=> 'info',
						'content' 				=> __( 'Please define the settings to style and customize your icon.', "ts_visual_composer_extend" ),
					),
					array(
						'id'					=> "icon",
						'type'					=> "iconpicker",
						'title'      	    	=> __( 'Select Icon', 'ts_visual_composer_extend' ),
						'settings' 				=> array(
							'emptyIcon' 				=> false,
							'emptyIconValue'			=> 'transparent',
							'type' 						=> 'extensions',
						),
						'default'				=> '',
						'generator'				=> 'ts-composium-shortcode',
						'help'					=> __( 'Select the icon you want to display.', "ts_visual_composer_extend" ),
					),
					// Link Settings
					array(
						"type"					=> "heading",
						"content"				=> __( 'Link Settings', "ts_visual_composer_extend" ),
					),
					array(
						'id'    				=> 'scroll_navigate',
						'type'  				=> 'select',
						'title' 				=> __( "Icon / Image Link Type", "ts_visual_composer_extend" ),
						'options'				=> array_flip(array(
							__( "No Link", "ts_visual_composer_extend" )                 		=> "none",
							__( "Standard Link", "ts_visual_composer_extend" )					=> "false",
							__( "In-Page Navigation Link", "ts_visual_composer_extend" )		=> "true",
							__( "Go-To-Top Link", "ts_visual_composer_extend" )                 => "gototop",							
						)),
						'default'  				=> 'none',						
						'chosen'      	    	=> true,
						'help'  				=> __( "Define what type of link you want to apply to the icon or image.", "ts_visual_composer_extend" ),
					),
					array(
						'id'        			=> "link",
						'type'              	=> "text",
						'title'           			=> __( "Link", "ts_visual_composer_extend" ),						
						'value'             	=> "",
						'help'       			=> __( "Enter the link to the page or file here (starting with http://).", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate', '==', 'false', true),
					),
					array(
						'id'        			=> "link_target",
						'type'              	=> "select",
						'title'           		=> __( "Link Target", "ts_visual_composer_extend" ),						
						'options'             	=> array_flip(array(
							__( "Same Window", "ts_visual_composer_extend" )                    => "_parent",
							__( "New Window", "ts_visual_composer_extend" )                     => "_blank"
						)),
						'chosen'				=> true,
						'help'       			=> __( "Select how the link should be opened.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('link', '!=', '', true),
					),	
					array(
						'id'            		=> "scroll_target",
						'type'                  => "text",
						'title'               	=> __( "Page Scroll Target", "ts_visual_composer_extend" ),						
						'value'                 => "",
						'help'           		=> __( "Enter the unique ID for the page section you want to scroll to.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate', '==', 'true', true),
					),
					array(
						'id'        			=> "scroll_offset",
						'type' 					=> "devicetypes",
						'title'           		=> __( "Device Type Scroll Offset", "ts_visual_composer_extend" ),
						'settings'				=> array(
							'unit'  					=> "px",
							'collapsed'					=> "true",
							'devices' 					=> array(
								"Desktop"           			=> array("default" => 0, "min" => 0, "max" => 250, "step" => 1),
								"Tablet"            			=> array("default" => 0, "min" => 0, "max" => 250, "step" => 1),
								"Mobile"            			=> array("default" => 0, "min" => 0, "max" => 250, "step" => 1),
							),
						),
						'value'					=> "desktop:0px;tablet:0px;mobile:0px",
						'help'					=> __( "Define an additional scroll offset to account for menu bars and other top fixed elements.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate', '==', 'true', true),
					),					
					array(
						'id'        			=> "scroll_placement",
						'type'              	=> "select",
						'title'           		=> __( "Link Placement", "ts_visual_composer_extend" ),						
						'options'             	=> array_flip(array(				
							__( "Top Left", "ts_visual_composer_extend" )						=> "topleft",
							__( "Top Center", "ts_visual_composer_extend" )						=> "topcenter",
							__( "Top Right", "ts_visual_composer_extend" )                 		=> "topright",
							__( "Center Left", "ts_visual_composer_extend" )					=> "centerleft",
							__( "Center Right", "ts_visual_composer_extend" )					=> "centerright",					
							__( "Bottom Left", "ts_visual_composer_extend" )                 	=> "bottomleft",
							__( "Bottom Center", "ts_visual_composer_extend" )                 	=> "bottomcenter",
							__( "Bottom Right", "ts_visual_composer_extend" )                 	=> "bottomright",
							__( "Default", "ts_visual_composer_extend" )						=> "default",
						)),
						'chosen'				=> true,
						'default'				=> "bottomright",
						"help"					=> __( "Define where on the screen the link should be placed; 'Default' equals position where this element has been placed in WP Bakery Page Builder.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate', '==', 'gototop', true),
					),
					array(
						'type'					=> "slider",
						'title'					=> __( "Offset: Left", "ts_visual_composer_extend" ),
						'param_name'			=> "scroll_left",
						'value'					=> "20",
						'min'					=> "0",
						'max'					=> "100",
						'step'					=> "1",
						'unit'					=> 'px',
						'help'					=> __( "Define the offset from the left screen side that should be used for the link.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate|scroll_placement', '==|any', 'gototop|topleft,centerleft,bottomleft', true),
					),
					array(
						'type'					=> "slider",
						'title'					=> __( "Offset: Right", "ts_visual_composer_extend" ),
						'param_name'			=> "scroll_right",
						'value'					=> "20",
						'min'					=> "0",
						'max'					=> "100",
						'step'					=> "1",
						'unit'					=> 'px',
						'help'					=> __( "Define the offset from the right screen side that should be used for the link.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate|scroll_placement', '==|any', 'gototop|topright,centerright,bottomright', true),
					),	
					array(
						'type'					=> "slider",
						'title'					=> __( "Offset: Top", "ts_visual_composer_extend" ),
						'param_name'			=> "scroll_top",
						'value'					=> "20",
						'min'					=> "0",
						'max'					=> "100",
						'step'					=> "1",
						'unit'					=> 'px',
						'help'					=> __( "Define the offset from the top screen side that should be used for the link.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate|scroll_placement', '==|any', 'gototop|topleft,topcenter,topright', true),
					),
					array(
						'type'					=> "slider",
						'title'					=> __( "Offset: Bottom", "ts_visual_composer_extend" ),
						'param_name'			=> "scroll_bottom",
						'value'					=> "20",
						'min'					=> "0",
						'max'					=> "100",
						'step'					=> "1",
						'unit'					=> 'px',
						'help'					=> __( "Define the offset from the bottom screen side that should be used for the link.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate|scroll_placement', '==|any', 'gototop|bottomleft,bottomcenter,bottomright', true),
					),
					array(
						'id'					=> "scroll_distance",
						'type'					=> "slider",
						'title'					=> __( "Scroll Distance", "ts_visual_composer_extend" ),						
						'value'					=> "200",
						'min'					=> "0",
						'max'					=> "600",
						'step'					=> "1",
						'unit'					=> 'px',
						'help'					=> __( "Define the required scroll distance from the top of the page in order to show the GoToTop link.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate|scroll_placement', '==|any', 'gototop|topleft,topcenter,topright,bottomleft,bottomcenter,bottomright,centerleft,centerright', true),
					),
					array(
						'id'					=> "scroll_speed",
						'type'					=> "slider",
						'title'					=> __( "Page Scroll Speed", "ts_visual_composer_extend" ),						
						'value'					=> "2000",
						'min'					=> "500",
						'max'					=> "10000",
						'step'					=> "100",
						'unit'					=> 'ms',
						'help'					=> __( "Define the speed that should be used to scroll to the section.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate', 'any', 'true,gototop', true),
					),					
					array(
						'id'            		=> "scroll_effect",
						'type'                 	=> "select",
						'title'               	=> __( "Page Scroll Easing", "ts_visual_composer_extend" ),
						'options' 				=> array_flip(TS_VCSC_Generator_Callbacks('easingtypes')),
						'chosen'				=> true,
						'help'           		=> __( "Select the easing animation that should be applied to the page scroll.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate', 'any', 'true,gototop', true),
					),
					array(
						'id'		    		=> "scroll_hashtag",
						'type'                  => "buttonswitch",
						'title'			    	=> __( 'Add Target as Hashtag', "ts_visual_composer_extend" ),
						'value'                 => "false",
						'help'		    		=> __( "Switch the toggle if you want to add the scroll target to the browser URL via hashtag.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate', '==', 'true', true),
					),
					// Size Settings
					array(
						"type"					=> "heading",
						"content"				=> __( 'Size Settings', "ts_visual_composer_extend" ),
					),
					array(
						'id'        			=> 'icon_size_type',
						'type'              	=> 'select',
						'title'           		=> __( "Icon / Image Size Type", "ts_visual_composer_extend" ),						
						'options'             	=> array_flip(array(
							__( "Pixel", "ts_visual_composer_extend" )							=> "px",
							__( "Points", "ts_visual_composer_extend" )							=> "pt",
							__( "EM", "ts_visual_composer_extend" )								=> "ems",
							__( "REM", "ts_visual_composer_extend" )							=> "rem",
							__( "Percent", "ts_visual_composer_extend" )                 		=> "%",					
							__( "Viewport Height", "ts_visual_composer_extend" )				=> "vh",
							__( "Viewport Width", "ts_visual_composer_extend" )					=> "vw",
						)),
						'default'  				=> 'px',						
						'chosen'      	    	=> true,
						'help'					=> __( "Define what size type you want to apply to the icon / image; select based on your intended usage.", "ts_visual_composer_extend" ),
					),
					array(
						"id"        			=> "icon_size_slide",
						"type"              	=> "slider",
						"title"           		=> __( "Icon / Image Size Value", "ts_visual_composer_extend" ),						
						"value"             	=> "30",
						"min"               	=> "16",
						"max"               	=> "512",
						"step"              	=> "1",
						"unit"              	=> 'px',
						"help"       			=> __( "Select the icon / image size in pixel.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('icon_size_type', '==', 'px', true),
					),
					array(
						"id"        			=> "icon_size_points",
						"type"              	=> "slider",
						"title"           		=> __( "Icon / Image Size Value", "ts_visual_composer_extend" ),						
						"value"             	=> "30",
						"min"               	=> "16",
						"max"               	=> "512",
						"step"              	=> "1",
						"unit"              	=> 'pt',
						"help"       			=> __( "Select the icon / image size in points.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('icon_size_type', '==', 'pt', true),
					),
					array(
						"id"        			=> "icon_size_ems",
						"type"              	=> "slider",
						"title"           		=> __( "Icon / Image Size Value", "ts_visual_composer_extend" ),						
						"value"             	=> "2",
						"min"               	=> "1",
						"max"               	=> "20",
						"step"              	=> "0.1",
						"decimals"				=> "1",
						"unit"              	=> 'em',
						"help"       			=> __( "Select the icon / image size in em.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('icon_size_type', '==', 'em', true),
					),
					array(
						"id"        			=> "icon_size_rem",
						"type"              	=> "slider",
						"title"           		=> __( "Icon / Image Size Value", "ts_visual_composer_extend" ),						
						"value"             	=> "2",
						"min"               	=> "1",
						"max"               	=> "20",
						"step"              	=> "0.1",
						"decimals"				=> "1",
						"unit"              	=> 'rem',
						"help"       			=> __( "Select the icon / image size in rem.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('icon_size_type', '==', 'rem', true),
					),
					array(
						"id"        			=> "icon_size_percent",
						"type"              	=> "slider",
						"title"           		=> __( "Icon / Image Size Value", "ts_visual_composer_extend" ),						
						"value"             	=> "200",
						"min"               	=> "100",
						"max"               	=> "1000",
						"step"              	=> "10",
						"unit"              	=> '%',
						"help"       			=> __( "Select the icon / image size in percent.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('icon_size_type', '==', '%', true),
					),			
					array(
						"id"        			=> "icon_size_viewheight",
						"type"              	=> "slider",
						"title"           		=> __( "Icon / Image Size Value", "ts_visual_composer_extend" ),						
						"value"             	=> "2",
						"min"               	=> "1",
						"max"               	=> "100",
						"step"              	=> "1",
						"unit"              	=> 'vh',
						"help"       			=> __( "Select the icon / image size in viewport height.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('icon_size_type', '==', 'vh', true),
					),
					array(
						"id"        			=> "icon_size_viewwidth",
						"type"              	=> "slider",
						"title"           		=> __( "Icon / Image Size Value", "ts_visual_composer_extend" ),						
						"value"             	=> "2",
						"min"               	=> "1",
						"max"               	=> "100",
						"step"              	=> "1",
						"unit"              	=> 'vw',
						"help"       			=> __( "Select the icon / image size in viewport width.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('icon_size_type', '==', 'vw', true),
					),
					// Color Settings
					array(
						"type"					=> "heading",
						"content"				=> __( 'Color Settings', "ts_visual_composer_extend" ),
					),
					array(
						'id'					=> "icon_color",
						'type'					=> "color",
						'title'      	    	=> __( "Icon Color", "ts_visual_composer_extend" ),
						'default'				=> '#CCCCCC',
						'help'					=> __( "Define the color of the icon.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('icon_replace', '==', 'false', true),
					),
					array(
						'id'					=> "icon_background",
						'type'					=> "color",
						'title'      	    	=> __( "Icon / Image Background Color", "ts_visual_composer_extend" ),
						'default'				=> 'rgba(255, 255, 255, 0)',
						'help'					=> __( "Define the background color for the icon / transparent image.", "ts_visual_composer_extend" ),
					),
					// Alignment Settings
					array(
						"type"					=> "heading",
						"content"				=> __( 'Alignment Settings', "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate', 'any', 'false,true,none', true),
					),
					array(
						'id'        			=> 'icon_align',
						'type'              	=> 'select',
						'title'           		=> __( "Icon / Image Align", "ts_visual_composer_extend" ),
						'options'             	=> array_flip(array(
							__( "No Align", "ts_visual_composer_extend" )                      => "none",
							__( "Float Left", "ts_visual_composer_extend" )                    => "left",
							__( "Float Right", "ts_visual_composer_extend" )                   => "right",
							__( "Center", "ts_visual_composer_extend" )                        => "center",
						)),
						'default'  				=> 'none',						
						'chosen'      	    	=> true,
						'help'       			=> __( "Select how to position the icon in the column.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate', 'any', 'false,true,none', true),
					),
					// Border Settings
					array(
						"type"					=> "heading",
						"content"				=> __( 'Border Settings', "ts_visual_composer_extend" ),
					),
					array(
						'id'        			=> 'icon_frame_type',
						'type'              	=> 'select',
						'title'           		=> __( "Icon / Image Border Type", "ts_visual_composer_extend" ),						
						'options'             	=> array_flip(array(
							__( "None", "ts_visual_composer_extend" )                          => "",
							__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
							__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
							__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
							__( "Double Border", "ts_visual_composer_extend" )                 => "double",
							__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
							__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
							__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
							__( "Outset Border", "ts_visual_composer_extend" )                 => "outset",
						)),
						'default'  				=> '',						
						'chosen'      	    	=> true,
						'help'       			=> __( "Select the type of border around the icon / image.", "ts_visual_composer_extend" ),
					),
					array(
						'id'        			=> "icon_frame_thick",
						'type'              	=> "slider",
						'title'           		=> __( "Icon / Image Border Thickness", "ts_visual_composer_extend" ),						
						'value'             	=> "1",
						'min'               	=> "1",
						'max'               	=> "10",
						'step'              	=> "1",
						'unit'              	=> 'px',
						'help'       			=> __( "Define the thickness of the icon / image border.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('icon_frame_type', 'any', implode(",", TS_VCSC_Generator_Callbacks('bordertypes')), true),
					),
					array(
						'id'        			=> "icon_frame_radius",
						'type'              	=> "select",
						'title'           	=> __( "Icon / Image Border Radius", "ts_visual_composer_extend" ),						
						'options'             	=> array_flip(array(
							__( "None", "ts_visual_composer_extend" )                          => "",
							__( "Small Radius", "ts_visual_composer_extend" )                  => "ts-radius-small",
							__( "Medium Radius", "ts_visual_composer_extend" )                 => "ts-radius-medium",
							__( "Large Radius", "ts_visual_composer_extend" )                  => "ts-radius-large",
							__( "Full Circle", "ts_visual_composer_extend" )                   => "ts-radius-full"
						)),
						'default'  				=> '',						
						'chosen'      	    	=> true,
						'help'       			=> __( "Define the radius of the icon / image border.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('icon_frame_type', 'any', implode(",", TS_VCSC_Generator_Callbacks('bordertypes')), true),
					),
					array(
						'id'        			=> "icon_frame_color",
						'type'              	=> "color",
						'title'           		=> __( "Icon / Image Frame Border Color", "ts_visual_composer_extend" ),						
						'value'             	=> "#000000",
						'help'       			=> __( "Define the color of the icon / image border.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('icon_frame_type', 'any', implode(",", TS_VCSC_Generator_Callbacks('bordertypes')), true),
					),
					// Spacing Settings
					array(
						'type'					=> "heading",
						'content'				=> __( 'Spacing Settings', "ts_visual_composer_extend" ),
					),
					array(
						'id'        			=> "padding",
						'type'					=> "buttonswitch",
						'title'           		=> __( "Apply Padding to Icon / Image", "ts_visual_composer_extend" ),						
						'value'             	=> "false",
						'help'       			=> __( "Switch the toggle if you want to apply a padding to the icon / image.", "ts_visual_composer_extend" ),
					),
					array(
						'id'        			=> "icon_padding",
						'type'              	=> "slider",
						'title'           		=> __( "Icon / Image Padding", "ts_visual_composer_extend" ),						
						'value'             	=> "0",
						'min'               	=> "0",
						'max'               	=> "50",
						'step'              	=> "1",
						'unit'              	=> 'px',
						'description'       	=> __( "If image instead of icon, increase the image size by padding value.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('padding', '==', 'true', true),
					),
					// Tooltip Settings
					array(
						"type"					=> "heading",
						"content"				=> __( 'Tooltip Settings', "ts_visual_composer_extend" ),
					),					
					array(
						'id'					=> "tooltip_css",
						'type'					=> "buttonswitch",
						'title'					=> __( "Use Advanced Tooltip", "ts_visual_composer_extend" ),						
						'value'					=> "false",
						'help'       			=> __( "Switch the toggle if you want to apply am advanced tooltip to the image.", "ts_visual_composer_extend" ),
					),
					array(
						'id'					=> "tooltip_content",
						'type'					=> "textarea",
						'title'					=> __( "Tooltip Content", "ts_visual_composer_extend" ),						
						'value'					=> "",
						'help'					=> __( "Enter the tooltip content here (do NOT use quotation marks or HTML).", "ts_visual_composer_extend" ),
						'dependency'   			=> array('tooltip_css', '==', 'false', true),
					),	
					array(
						'id'					=> "tooltip_base64",
						'type'					=> "base64textarea",
						'title'					=> __( "Tooltip Content", "ts_visual_composer_extend" ),						
						'value'					=> "",
						'help'					=> __( "Enter the tooltip content here; you can use special characters as well.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('tooltip_css', '==', 'true', true),
					),					
					array(
						'id'					=> "tooltip_position",
						'type'					=> "select",
						'title'					=> __( "Tooltip Position", "ts_visual_composer_extend" ),						
						'options'				=> array_flip(TS_VCSC_Generator_Callbacks('tooltipsvertical')),
						'chosen'      	    	=> true,
						'help'					=> __( "Select the tooltip position in relation to the image.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('tooltip_css', '==', 'true', true),
					),
					array(
						'id'					=> "tooltip_style",
						'type'					=> "select",
						'title'					=> __( "Tooltip Style", "ts_visual_composer_extend" ),						
						'options'             	=> array_flip(TS_VCSC_Generator_Callbacks('tooltipsstyles')),
						'chosen'      	    	=> true,
						'help'					=> __( "Select the tooltip style.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('tooltip_css', '==', 'true', true),
					),
					array(
						'id'		    		=> "tooltip_animation",
						'type'				    => "select",
						'title'			    	=> __( "Tooltip Animation", "ts_visual_composer_extend" ),						
						'options'				=> array_flip(TS_VCSC_Generator_Callbacks('tooltipsanimations')),
						'chosen'      	    	=> true,
						'help'		    		=> __( "Select how the tooltip entry and exit should be animated once triggered.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('tooltip_css', '==', 'true', true),
					),
					array(
						'id'					=> "tooltipster_offsetx",
						'type'					=> "slider",
						'title'					=> __( "Tooltip X-Offset", "ts_visual_composer_extend" ),						
						'value'					=> "0",
						'min'					=> "-100",
						'max'					=> "100",
						'step'					=> "1",
						'unit'					=> 'px',
						'help'					=> __( "Define an optional X-Offset for the tooltip position.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('tooltip_css', '==', 'true', true),
					),
					array(
						'id'					=> "tooltipster_offsety",
						'type'					=> "slider",
						'title'					=> __( "Tooltip Y-Offset", "ts_visual_composer_extend" ),						
						'value'					=> "0",
						'min'					=> "-100",
						'max'					=> "100",
						'step'					=> "1",
						'unit'					=> 'px',
						'help'					=> __( "Define an optional Y-Offset for the tooltip position.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('tooltip_css', '==', 'true', true),
					),
					// Animation Settings
					array(
						'type'					=> "heading",
						'content'				=> __( 'Animation Settings', "ts_visual_composer_extend" ),
					),					
					array(
						'id'					=> "animation_active",
						'type'					=> "css3animations",
						'title'					=> __("Icon / Image Active Animation", "ts_visual_composer_extend"),
						'settings'				=> array(
							'prefix'					=> "ts-infinite-css-",
							'connector'					=> "TS-VCSC-Font-Icons[css3animations_active]",
							'noneselect'				=> "true",
						),
						'default'				=> "",
						'value'					=> "",
						'help'					=> __("Select the active animation for the icon / image.", "ts_visual_composer_extend"),
						'dependency'   			=> array('scroll_navigate', 'any', 'true,false,none', true),
					),
					array(
						'id'					=> "css3animations_active",
						'type'					=> "inputhidden",
						'title'					=> __( "Icon / Image Active Animation", "ts_visual_composer_extend" ),						
						'value'					=> "",
						'dependency'   			=> array('scroll_navigate', 'any', 'true,false,none', true),
					),					
					array(
						'id'					=> "animation_icon",
						'type'					=> "css3animations",
						'title'					=> __("Icon / Image Hover Animation", "ts_visual_composer_extend"),
						'settings'				=> array(
							'prefix'					=> "ts-hover-css-",
							'connector'					=> "TS-VCSC-Font-Icons[css3animations_in]",
							'noneselect'				=> "true",
						),
						'default'				=> "",
						'value'					=> "",
						'help'					=> __("Select the hover animation for the icon / image.", "ts_visual_composer_extend"),
						'dependency'   			=> array('scroll_navigate', 'any', 'true,false,none', true),
					),
					array(
						'id'					=> "css3animations_in",
						'type'					=> "inputhidden",
						'title'					=> __( "Icon / Image Hover Animation", "ts_visual_composer_extend" ),				
						'value'					=> "",
						'dependency'   			=> array('scroll_navigate', 'any', 'true,false,none', true),
					),
					array(
						'id'					=> "animation_view",
						'type'					=> "css3animations",
						'title'					=> __("Icon / Image Viewport Animation", "ts_visual_composer_extend"),
						'settings'				=> array(
							'prefix'					=> "ts-viewport-css-",
							'connector'					=> "TS-VCSC-Font-Icons[css3animations_view]",
							'noneselect'				=> "true",
						),
						'default'				=> "",
						'value'					=> "",
						'help'					=> __("Select the viewport animation for the icon / image.", "ts_visual_composer_extend"),
						'dependency'   			=> array('scroll_navigate', 'any', 'true,false,none', true),
					),
					array(
						'id'					=> "css3animations_view",
						'type'					=> "inputhidden",
						'title'					=> __( "Icon / Image Viewport Animation", "ts_visual_composer_extend" ),						
						'value'					=> "",
						'dependency'   			=> array('scroll_navigate', 'any', 'true,false,none', true),
					),
					array(
						'id'        			=> "animation_delay",
						'type'              	=> "slider",
						'title'           		=> __( "Animation Delay", "ts_visual_composer_extend" ),						
						'value'             	=> "0",
						'min'               	=> "0",
						'max'               	=> "10000",
						'step'              	=> "100",
						'unit'              	=> 'ms',
						'help'       			=> __( "Define an optional delay for the viewport animation.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('animation_view', '!=', '', true),
					),
					array(
						'id'					=> "animation_totopin",
						'type'					=> "css3animations",
						'title'					=> __("Icon / Image In-Animation", "ts_visual_composer_extend"),
						'settings'				=> array(
							'prefix'					=> "ts-viewport-css-",
							'connector'					=> "TS-VCSC-Font-Icons[css3animations_totopin]",
							'noneselect'				=> "true",
						),
						'default'				=> "",
						'value'					=> "",
						'help'					=> __("Select the in animation for the GoToTop link.", "ts_visual_composer_extend"),
						'dependency'   			=> array('scroll_navigate', '==', 'gototop', true),
					),
					array(
						'id'					=> "css3animations_totopin",
						'type'					=> "inputhidden",
						'title'					=> __( "Icon / Image In-Animation", "ts_visual_composer_extend" ),				
						'value'					=> "",
						'dependency'   			=> array('scroll_navigate', '==', 'gototop', true),
					),
					array(
						'id'					=> "animation_totopout",
						'type'					=> "css3animations",
						'title'					=> __("Icon / Image Out-Animation", "ts_visual_composer_extend"),
						'settings'				=> array(
							'prefix'					=> "ts-viewport-css-",
							'connector'					=> "TS-VCSC-Font-Icons[css3animations_totopout]",
							'noneselect'				=> "true",
						),
						'default'				=> "",
						'value'					=> "",
						'help'					=> __("Select the out animation for the GoToTop link.", "ts_visual_composer_extend"),
						'dependency'   			=> array('scroll_navigate', '==', 'gototop', true),
					),
					array(
						'id'					=> "css3animations_totopout",
						'type'					=> "inputhidden",
						'title'					=> __( "Icon / Image In-Animation", "ts_visual_composer_extend" ),				
						'value'					=> "",
						'dependency'   			=> array('scroll_navigate', '==', 'gototop', true),
					),	
					// Other Settings
					array(
						'type'					=> "heading",
						'content'				=> __( 'Other Settings', "ts_visual_composer_extend" ),
					),					
					array(
						'id'            		=> "margin_top",
						'type'                  => "slider",
						'title'               	=> __( "Margin: Top", "ts_visual_composer_extend" ),						
						'value'                 => "0",
						'min'                   => "0",
						'max'                   => "200",
						'step'                  => "1",
						'unit'                  => 'px',
						'help'           		=> __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate', 'any', 'false,true', true),
					),
					array(
						'id'            		=> "margin_bottom",
						'type'                  => "slider",
						'title'               	=> __( "Margin: Bottom", "ts_visual_composer_extend" ),						
						'value'                 => "0",
						'min'                   => "0",
						'max'                   => "200",
						'step'                  => "1",
						'unit'                  => 'px',
						'help'           		=> __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
						'dependency'   			=> array('scroll_navigate', 'any', 'false,true', true),
					),					
					array(
						'id' 					=> 'el_id',
						'type' 					=> 'text',
						'title' 				=> __( "Custom ID Name", "ts_changelog_organizer" ),
						'help' 					=> __( "Define an optional custom ID name that should be assigned to the element.", "ts_visual_composer_extend" ),
					),
					array(
						'id' 					=> 'el_class',
						'type' 					=> 'tageditor',
						"delimiter"				=> ", ",
						"numbersonly"			=> "false",
						'title' 				=> __( "Custom Class Name(s)", "ts_changelog_organizer" ),
						'help' 					=> __( "Define optional custom class name(s) that should be assigned to the element.", "ts_visual_composer_extend" ),
					),
                )
            ));
		}
	}
	
	if (is_admin()) {
		//add_action('plugins_loaded',			'TS_VCSC_Generator_Fields',                   999999999);
		add_action('csf_loaded',				'TS_VCSC_Generator_Fields',                   999999999);
	}
?>